class GlobalUser {
  final String? id;
  final String? packageId;
  final String? validity;
  final dynamic telegramUsername;
  final String? firstName;
  final String? lastName;
  final String? username;
  final String? email;
  final String? provider;
  final String? countryCode;
  final String? mobile;
  final String? refBy;
  final String? balance;
  final dynamic image;
  final dynamic imageUrl;
  final String? status;
  final String? exp;
  final String? ev;
  final String? sv;
  final dynamic verCode;
  final dynamic verCodeSendAt;
  final String? ts;
  final String? tv;
  final dynamic tsc;
  final String? profileComplete;
  final String? buyFreePackage;
  final String? address;
  final String? state;
  final String? zip;
  final String? country;
  final String? city;
  final String? createdAt;
  final String? updatedAt;

  const GlobalUser({
    this.id,
    this.packageId,
    this.validity,
    this.telegramUsername,
    this.firstName,
    this.lastName,
    this.username,
    this.email,
    this.provider,
    this.countryCode,
    this.mobile,
    this.refBy,
    this.balance,
    this.image,
    this.imageUrl,
    this.status,
    this.exp,
    this.ev,
    this.sv,
    this.verCode,
    this.verCodeSendAt,
    this.ts,
    this.tv,
    this.tsc,
    this.profileComplete,
    this.buyFreePackage,
    this.address,
    this.state,
    this.zip,
    this.country,
    this.city,
    this.createdAt,
    this.updatedAt,
  });

  factory GlobalUser.fromJson(Map<String, dynamic> json) {
    return GlobalUser(
      id: json['id']?.toString(),
      packageId: json['package_id']?.toString(),
      validity: json['validity']?.toString(),
      telegramUsername: json['telegram_username'],
      firstName: json['firstname'],
      lastName: json['lastname'],
      username: json['username'] ?? '',
      email: json['email'],
      provider: json['provider'],
      countryCode: json['country_code']?.toString(),
      mobile: json['mobile']?.toString(),
      refBy: json['ref_by']?.toString(),
      balance: json['balance']?.toString(),
      image: json['image'],
      imageUrl: json['imageUrl'],
      status: json['status']?.toString(),
      exp: json['exp'] != null ? json['exp'].toString() : '',
      ev: json['ev']?.toString(),
      sv: json['sv']?.toString(),
      profileComplete: json['profile_complete']?.toString(),
      verCode: json['ver_code'],
      verCodeSendAt: json['ver_code_send_at'],
      ts: json['ts']?.toString(),
      tv: json['tv']?.toString(),
      tsc: json['tsc'],
      buyFreePackage: json['buy_free_package']?.toString(),
      address: json['address'],
      state: json['state'],
      zip: json['zip'],
      country: json['country'],
      city: json['city'],
      createdAt: json['created_at'],
      updatedAt: json['updated_at'],
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'id': id,
      'package_id': packageId,
      'validity': validity,
      'telegram_username': telegramUsername,
      'firstname': firstName,
      'lastname': lastName,
      'username': username,
      'email': email,
      'provider': provider,
      'country_code': countryCode,
      'mobile': mobile,
      'ref_by': refBy,
      'balance': balance,
      'image': image,
      'imageUrl': imageUrl,
      'status': status,
      'exp': exp,
      'ev': ev,
      'sv': sv,
      'ver_code': verCode,
      'ver_code_send_at': verCodeSendAt,
      'ts': ts,
      'tv': tv,
      'tsc': tsc,
      'profile_complete': profileComplete,
      'buy_free_package': buyFreePackage,
      'address': address,
      'state': state,
      'zip': zip,
      'country': country,
      'city': city,
      'created_at': createdAt,
      'updated_at': updatedAt,
    };
  }
}
